
document.addEventListener("DOMContentLoaded", function () {
  const fadeSections = document.querySelectorAll('.fade-section');
  const options = { threshold: 0.0 };

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('visible');
        observer.unobserve(entry.target);
      }
    });
  }, options);

  fadeSections.forEach(section => {
    observer.observe(section);
  });
});
